/*
EditPoly Operations MacroScript File

Created:  		Aug 19 2000
Revision History: 	
	
	Feb 25, 2002, by Steve Anderson - heavily reorganized.
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products

	28 May 2004, Steve Anderson
		Added support for Edit Poly modifier to most scripts.

EditPoly operations Macroscript file.

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--

-- *******************************************************************
--  Poly Ops: Selection
-- *******************************************************************

MacroScript EPoly_Shrink
ButtonText:~EPOLY_SHRINK_BUTTONTEXT~
Category:~EPOLY_SHRINK_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SHRINK_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #ShrinkSelection
		)
		Catch (MessageBox ~MSGBOX_OPERATION_FAILED~ Title:~MSGBOX_OPERATION_TITLE~)
	)
)

MacroScript EPoly_Grow
ButtonText:~EPOLY_GROW_BUTTONTEXT~
Category:~EPOLY_GROW_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_GROW_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #GrowSelection
		)
		Catch (MessageBox ~EPOLY_GROW_MSGBOX_OPERATION_FAILED~ Title:~EPOLY_GROW_MSGBOX_OPERATION_TITLE~)
	)
)

MacroScript EPoly_Select_Loop
ButtonText:~EPOLY_SELECT_LOOP_BUTTONTEXT~
Category:~EPOLY_SELECT_LOOP_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SELECT_LOOP_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..5}

	On Execute Do (
		Try (
			if subobjectlevel == undefined then max modify mode
			PolyToolsSelect.Loop keyboard.shiftpressed
		)
		Catch (MessageBox ~EPOLY_SELECT_LOOP_OP_FAILED~ Title:~EPOLY_SELECT_LOOP_OP_TITLE~)
	)
)

MacroScript EPoly_Select_Ring
ButtonText:~EPOLY_SELECT_RING_BUTTONTEXT~
Category:~EPOLY_SELECT_RING_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SELECT_RING_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..5}

	On Execute Do (
		Try (
			if subobjectlevel == undefined then max modify mode
			PolyToolsSelect.Ring()
		)
		Catch (MessageBox ~MSGBOX_EPOLY_SELECT_RING_CAPTION~ Title:~MSGBOX_EPOLY_SELECT_RING_TITLE~)
	)
)

-- *******************************************************************
--  Poly Ops: Edit Geometry
-- *******************************************************************

MacroScript EPoly_Repeat_Last
ButtonText:~EPOLY_REPEAT_LAST_BUTTONTEXT~
Category:~EPOLY_REPEAT_LAST_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_REPEAT_LAST_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do
	(
		Try (
			local A = Filters.GetModOrObj()
			A.RepeatLastOperation ()
		)
		Catch (MessageBox ~EPOLY_REPEAT_LAST_MSGBOX_CAPTION~ Title:~EPOLY_REPEAT_LAST_MSGBOX_TITLE~)
	)
)

MacroScript EPoly_Collapse
ButtonText:~EPOLY_COLLAPSE_BUTTONTEXT~
Category:~EPOLY_COLLAPSE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_COLLAPSE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectLevel == 1) then (A.ButtonOp #CollapseVertex)
				else if (subobjectLevel>1) and (subobjectLevel<4) then (A.ButtonOp #CollapseEdge)
				else if (subobjectLevel>3) then (A.ButtonOp #CollapseFace)
			)
			else (A.buttonOp #Collapse)
		)
		Catch (MessageBox ~EPOLY_COLLAPSE_MSGBOX_CAPTION~ Title:~EPOLY_COLLAPSE_MSGBOX_TITLE~)
	)
)

MacroScript EPoly_Attach
ButtonText:~EPOLY_ATTACH_BUTTONTEXT~
Category:~EPOLY_ATTACH_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_ATTACH_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		local A = Filters.GetModOrObj()
		(Filters.Is_This_EditPolyMod A) and (A.GetPickMode() == #Attach)
	)

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		A.enterPickMode #Attach
	)
	
	On AltExecute type Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		if (Filters.Is_This_EditPolyObj A) then (A.buttonOp #AttachList)
		else (A.PopupDialog #Attach)
	)
)

MacroScript EPoly_Detach
ButtonText:~EPOLY_DETACH_BUTTONTEXT~
Category:~EPOLY_DETACH_CATEGORY~
internalCategory:"Editable Polygon Object"
Tooltip:~EPOLY_DETACH_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do
	(
		Try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyObj A) then (
				if (A.GetMeshSelLevel() != #Object) then $.EditablePoly.buttonOp #Detach
			) else (
				if (subobjectlevel == 1) then (A.PopupDialog #DetachVertex)
				else if (subobjectLevel > 1) then (A.PopupDialog #DetachFace)
			)
		)
		Catch(MessageBox ~EPOLY_DETACH_CAPTION~ Title:~EPOLY_DETACH_TITLE~)
	)
)

MacroScript EPoly_SlicePlane
ButtonText:~EPOLY_SLICEPLANE_BUTTONTEXT~
Category:~EPOLY_SLICEPLANE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SLICEPLANE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..6}
	On IsChecked Return Filters.Is_EPoly_SliceMode()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #SlicePlane
		)
		Catch(MessageBox ~EPOLY_SLICEPLANE_CAPTION~ Title:~EPOLY_SLICEPLANE_TITLE~)
	)
)

MacroScript EPoly_Slice
ButtonText:~EPOLY_SLICE_BUTTONTEXT~
Category:~EPOLY_SLICE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SLICE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return (Filters.Is_EPoly_SliceMode())
	On IsVisible Return (Filters.Is_EPoly_SliceMode())

	On Execute Do (
		Try	(
			local A = Filters.GetModOrObj()
			if (A.inSlicePlaneMode ()) then (
				if (Filters.Is_This_EditPolyMod A) then (A.CommitAndRepeat())
				else (A.buttonOp #Slice)
			)
		)
		Catch(MessageBox ~EPOLY_SLICE_CAPTION~ Title:~EPOLY_SLICE_TITLE~)
	)
)

MacroScript EPoly_resetPlane
ButtonText:~EPOLY_RESETPLANE_BUTTONTEXT~
Category:~EPOLY_RESETPLANE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_RESETPLANE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return (Filters.Is_EPoly_SliceMode())
	On IsVisible Return (Filters.Is_EPoly_SliceMode())

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #ResetSlicePlane
		)
		Catch(MessageBox ~EPOLY_RESETPLANE_CAPTION~ Title:~EPOLY_RESETPLANE_TITLE~)
	)
)

MacroScript EPoly_Quickslice
ButtonText:~EPOLY_QUICKSLICE_BUTTONTEXT~
Category:~EPOLY_QUICKSLICE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_QUICKSLICE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#Quickslice)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ToggleCommandMode #Quickslice
		)
		Catch(MessageBox ~EPOLY_QUICKSLICE_CAPTION~ Title:~EPOLY_QUICKSLICE_TITLE~)
	)
)

MacroScript EPoly_Cut
ButtonText:~EPOLY_CUT_BUTTONTEXT~
Category:~EPOLY_CUT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CUT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#Cut)
		)
		catch ( false )
	)


	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then (A.ToggleCommandMode #Cut)
			else (A.toggleCommandMode #CutVertex)	-- (Really a general Cut mode.)
		)
		Catch(MessageBox ~EPOLY_CUT_CAPTION~ Title:~EPOLY_CUT_TITLE~)
	)
)

MacroScript EPoly_Meshsmooth
ButtonText:~EPOLY_MESHSMOOTH_BUTTONTEXT~
Category:~EPOLY_MESHSMOOTH_CATEGORY~
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_MESHSMOOTH_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #MeshSmooth
			)
		)
		Catch(MessageBox ~EPOLY_MESHSMOOTH_CAPTION~ Title:~EPOLY_MESHSMOOTH_TITLE~)
	)
	On AltExecute type Do (
		Try (
			local A = Filters.GetModOrObj()
			A.popupDialog #MeshSmooth
		)
		Catch(MessageBox ~EPOLY_MESHSMOOTH_OP_FAILED_CAPTION~ Title:~EPOLY_MESHSMOOTH_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Tessellate
ButtonText:~EPOLY_TESSELLATE_BUTTONTEXT~
Category:~EPOLY_TESSELLATE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_TESSELLATE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #Tessellate
			)
		)
		Catch(MessageBox ~EPOLY_TESSELLATE_CAPTION~ Title:~EPOLY_TESSELLATE_TITLE~)
	)
	On AltExecute type Do (
		Try (
			local A = Filters.GetModOrObj()
			A.popupDialog #Tessellate
		)
		Catch(MessageBox ~EPOLY_TESSELLATE_OP_FAILED_CAPTION~ Title:~EPOLY_TESSELLATE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Make_Planar
ButtonText:~EPOLY_MAKE_PLANAR_BUTTONTEXT~
Category:~EPOLY_MAKE_PLANAR_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_MAKE_PLANAR_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..6}	-- anything but object
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..6}	-- anything but object

	On Execute Do (
		If SubObjectLevel == undefined then Max Modify Mode
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #MakePlanar
		)
		Catch(MessageBox ~EPOLY_MAKE_PLANAR_CAPTION~ Title:~EPOLY_MAKE_PLANAR_TITLE~)
	)
)

MacroScript EPoly_View_Align
ButtonText:~EPOLY_VIEW_ALIGN_BUTTONTEXT~
Category:~EPOLY_VIEW_ALIGN_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VIEW_ALIGN_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #AlignView
		)
		Catch(MessageBox ~EPOLY_VIEW_ALIGN_CAPTION~ Title:~EPOLY_VIEW_ALIGN_TITLE~)
	)

)

MacroScript EPoly_Grid_Align
ButtonText:~EPOLY_GRID_ALIGN_BUTTONTEXT~
Category:~EPOLY_GRID_ALIGN_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_GRID_ALIGN_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			A.buttonOp #AlignGrid
		)
		Catch(MessageBox ~EPOLY_GRID_ALIGN_CAPTION~ Title:~EPOLY_GRID_ALIGN_TITLE~)
	)
)

MacroScript EPoly_Hide
ButtonText:~EPOLY_HIDE_BUTTONTEXT~
Category:~EPOLY_HIDE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_HIDE_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try(
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectlevel == 1) then A.ButtonOp #HideVertex
				else A.ButtonOp #HideFace
			)
			else A.buttonOp #HideSelection
		)
		Catch(MessageBox ~EPOLY_HIDE_CAPTION~ Title:~EPOLY_HIDE_TITLE~)
	)

)

MacroScript EPoly_Hide_Unselected
ButtonText:~EPOLY_HIDE_UNSELECTED_BUTTONTEXT~
Category:~EPOLY_HIDE_UNSELECTED_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_HIDE_UNSELECTED_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try(
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectlevel == 1) then A.ButtonOp #HideUnselectedVertex
				else A.ButtonOp #HideUnselectedFace
			)
			else A.buttonOp #HideUnselected
		)
		Catch(MessageBox ~EPOLY_HIDE_UNSELECTED_CAPTION~ Title:~EPOLY_HIDE_UNSELECTED_TITLE~)
	)

)

MacroScript EPoly_UnHide
ButtonText:~EPOLY_UNHIDE_BUTTONTEXT~
Category:~EPOLY_UNHIDE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_UNHIDE_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectlevel == 1) then A.ButtonOp #UnhideAllVertex
				else A.ButtonOp #UnhideAllFace
			)
			else A.buttonOp #UnhideAll
		)
		Catch(MessageBox ~EPOLY_UNHIDE_CAPTION~ Title:~EPOLY_UNHIDE_TITLE~)
	)
)


-- *******************************************************************
--  Poly Ops:  Generalized versions of SO-specific operations
--             This section lets users simply call "Extrude",
--			   "Chamfer", etc, and it uses the current SO mode.
-- *******************************************************************

MacroScript EPoly_Create
ButtonText:~EPOLY_CREATE_BUTTONTEXT~
Category:~EPOLY_CREATE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CREATE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local mode = A.GetCommandMode
				(mode == #CreateVertex) or (mode == #CreateEdge) or (mode == #CreateFace)
			)
			else false
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			local msl = A.GetMeshSelLevel ()
			if msl == #vertex then (A.toggleCommandMode #CreateVertex)
			else (
				if msl == #edge then (A.toggleCommandMode #CreateEdge)
				else (A.toggleCommandMode #CreateFace)
			)
		)
		Catch(MessageBox ~EPOLY_CREATE_CAPTION~ Title:~EPOLY_CREATE_TITLE~)
	)
)

MacroScript EPoly_Remove
ButtonText:~EPOLY_REMOVE_BUTTONTEXT~
Category:~EPOLY_REMOVE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_REMOVE_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..3}

	On Execute Do (
		try (
			if subobjectlevel == undefined then max modify mode
			local A = Filters.GetModOrObj()
			if ((subobjectLevel==1) or (subobjectLevel==2)) then (
				if (Filters.Is_This_EditPolyMod A) then
				(
					if (subobjectLevel == 1) then A.ButtonOp #RemoveVertex
					else A.ButtonOp #RemoveEdge
				)
				else A.buttonOp #Remove
			) else (
				-- Put us in a suitable SO level
				subobjectLevel = 2
			)
		)
		catch (MessageBox ~EPOLY_REMOVE_CAPTION~ Title:~EPOLY_REMOVE_TITLE~)
	)
)

MacroScript EPoly_InsertVertex
ButtonText:~EPOLY_INSERTVERTEX_BUTTONTEXT~
Category:~EPOLY_INSERTVERTEX_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_INSERTVERTEX_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Edge, Border, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local mode = A.GetCommandMode()
				(mode == #DivideEdge) or (mode == #DivideFace)
			)
			else false
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			-- default to Edge:
			if subobjectLevel < 2 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			msl = A.GetMeshSelLevel ()
			if msl == #Edge then (A.toggleCommandMode #DivideEdge)
			if msl == #Face then (A.toggleCommandMode #DivideFace)
		)
		Catch(MessageBox ~EPOLY_INSERTVERTEX_CAPTION~ Title:~EPOLY_INSERTVERTEX_TITLE~)
	)
)

MacroScript EPoly_Extrude
ButtonText:~EPOLY_EXTRUDE_BUTTONTEXT~
Category:~EPOLY_EXTRUDE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_EXTRUDE_TOOLTIP~ 
-- Needs Icon
(
	-- Active in any SO level:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			local mode = A.GetCommandMode()
			(mode == #ExtrudeVertex) or (mode == #ExtrudeEdge) or (mode == #ExtrudeFace)

		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			-- default to Face level:
			if subobjectLevel == 0 then subobjectLevel = 4
			if subobjectLevel == 5 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			msl = A.GetMeshSelLevel ()
			if msl == #vertex then (A.toggleCommandMode #ExtrudeVertex)
			if msl == #edge then (A.toggleCommandMode #ExtrudeEdge)
			if msl == #face then (A.toggleCommandMode #ExtrudeFace)
		)
		Catch(MessageBox ~EPOLY_EXTRUDE_CAPTION~ Title:~EPOLY_EXTRUDE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			-- default to Face level:
			if subobjectLevel == 0 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then
			(
				local level = A.GetMeshSelLevel()
				if (level == #Vertex) then (A.PopupDialog #ExtrudeVertex)
				else if (level == #Edge) then (A.PopupDialog #ExtrudeEdge)
				else if (level == #Face) then (A.PopupDialog #ExtrudeFace)
			)
			else (A.popupDialog #Extrude)
		)
		Catch(MessageBox ~EPOLY_EXTRUDE_OP_FAILED_CAPTION~ Title:~EPOLY_EXTRUDE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Chamfer
ButtonText:~EPOLY_CHAMFER_BUTTONTEXT~
Category:~EPOLY_CHAMFER_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CHAMFER_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Edge, Border levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..4}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			local mode = A.GetCommandMode()
			(mode == #ChamferVertex) or (mode == #ChamferEdge)

		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			-- default to Edge level:
			if subobjectLevel > 3 then subobjectLevel = 2
			if subobjectLevel == 0 then subobjectLevel = 2
			if subobjectLevel == 1 then (A.toggleCommandMode #ChamferVertex)
			else (A.toggleCommandMode #ChamferEdge)
		)
		Catch(MessageBox ~EPOLY_CHAMFER_CAPTION~ Title:~EPOLY_CHAMFER_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			-- default to Edge level:
			if subobjectLevel > 3 then subobjectLevel = 2
			if subobjectLevel == 0 then subobjectLevel = 2
			if (Filters.Is_This_EditPolyMod A) then
			(
				if (subobjectLevel == 1) then (A.PopupDialog #ChamferVertex)
				else (A.PopupDialog #ChamferEdge)
			)
			else (A.popupDialog #Chamfer)
		)
		Catch(MessageBox ~EPOLY_CHAMFER_OP_FAILED_CAPTION~ Title:~EPOLY_CHAMFER_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Weld
ButtonText:~EPOLY_WELD_BUTTONTEXT~
Category:~EPOLY_WELD_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_WELD_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..3}

	On Execute Do (
		Try (
			if subobjectlevel == undefined then max modify mode
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then 
			(
				if (subobjectLevel == 1) then A.ButtonOp #WeldVertex
				else A.buttonOp #WeldEdge
			)
			else A.buttonOp #WeldSelected
		)
		Catch(MessageBox ~EPOLY_WELD_CAPTION~ Title:~EPOLY_WELD_TITLE~)
	)

	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then
			(
				if (subobjectLevel == 1) then A.PopupDialog #WeldVertex
				else A.popupDialog #WeldEdge
			)
			else A.popupDialog #WeldSelected
		)
		Catch(MessageBox ~EPOLY_WELD_OP_FAILED_CAPTION~ Title:~EPOLY_WELD_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_TargetWeld
ButtonText:~EPOLY_TARGETWELD_BUTTONTEXT~
Category:~EPOLY_TARGETWELD_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_TARGETWELD_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..3}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(A.GetCommandMode() == #Weld)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined do (Max Modify Mode)
			local A = Filters.GetModOrObj ()
			A.toggleCommandMode #Weld
		)
		Catch(MessageBox ~EPOLY_TARGETWELD_CAPTION~ Title:~EPOLY_TARGETWELD_TITLE~)
	)
)

-- We need two versions of this Connect macro, even though we really want one,
-- because the edge level has an altExecute method and the vertex level doesn't.
-- There's no way as yet to suppress the altExecute icon in vertex level.
-- (Should be something like On IsAltVisible...)

MacroScript EPoly_Connect
ButtonText:~EPOLY_CONNECT_BUTTONTEXT~
Category:~EPOLY_CONNECT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CONNECT_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Edge, levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		A.buttonOp #ConnectVertices
	)
)

MacroScript EPoly_Connect2
ButtonText:~EPOLY_CONNECT2_BUTTONTEXT~
Category:~EPOLY_CONNECT2_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CONNECT2_TOOLTIP~ 
-- Needs Icon
(
	-- Active in Vertex, Edge levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3}

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		local A = Filters.GetModOrObj()
		A.buttonOp #ConnectEdges
	)

	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #ConnectEdges
		)
		Catch(MessageBox ~EPOLY_CONNECT2_CAPTION~ Title:~EPOLY_CONNECT2_TITLE~)
	)
)

-- *******************************************************************
--  Poly Ops:  Vertex specific stuff
-- *******************************************************************

MacroScript EPoly_Break
ButtonText:~EPOLY_BREAK_BUTTONTEXT~
Category:~EPOLY_BREAK_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_BREAK_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #BreakVertex
		)
		Catch(MessageBox ~EPOLY_BREAK_CAPTION~ Title:~EPOLY_BREAK_TITLE~)
	)
)

MacroScript EPoly_RemoveIsolatedVerts
ButtonText:~EPOLY_REMOVEISOLATEDVERTS_BUTTONTEXT~
Category:~EPOLY_REMOVEISOLATEDVERTS_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_REMOVEISOLATEDVERTS_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #RemoveIsoVerts
		)
		Catch(MessageBox ~EPOLY_REMOVEISOLATEDVERTS_CAPTION~ Title:~EPOLY_REMOVEISOLATEDVERTS_TITLE~)
	)
)

MacroScript EPoly_RemoveIsolatedMapVerts
ButtonText:~EPOLY_REMOVEISOLATEDMAPVERTS_BUTTONTEXT~
Category:~EPOLY_REMOVEISOLATEDMAPVERTS_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_REMOVEISOLATEDMAPVERTS_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #RemoveIsoMapVerts
		)
		Catch(MessageBox ~EPOLY_REMOVEISOLATEDMAPVERTS_CAPTION~ Title:~EPOLY_REMOVEISOLATEDMAPVERTS_TITLE~)
	)
)


-- *******************************************************************
-- Poly Ops:  Edit Edges
-- *******************************************************************

MacroScript EPoly_Split
ButtonText:~EPOLY_SPLIT_BUTTONTEXT~
Category:~EPOLY_SPLIT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SPLIT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 2 then subobjectlevel = 2
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #SplitEdges
			)
		)
		Catch(MessageBox ~EPOLY_SPLIT_CAPTION~ Title:~EPOLY_SPLIT_TITLE~)
	)
)

MacroScript EPoly_ShapeFromEdges
ButtonText:~EPOLY_SHAPEFROMEDGES_BUTTONTEXT~
Category:~EPOLY_SHAPEFROMEDGES_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SHAPEFROMEDGES_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..4}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then (A.PopupDialog #CreateShape)
			else (A.buttonOp #CreateShape)
		)
		Catch(MessageBox ~EPOLY_SHAPEFROMEDGES_CAPTION~ Title:~EPOLY_SHAPEFROMEDGES_TITLE~)
	)
)

-- *******************************************************************
-- Poly Ops:  Border specific stuff
-- *******************************************************************

MacroScript EPoly_Cap
ButtonText:~EPOLY_CAP_BUTTONTEXT~
Category:~EPOLY_CAP_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CAP_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{4}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.buttonOp #Cap
		)
		Catch(MessageBox ~EPOLY_CAP_CAPTION~ Title:~EPOLY_CAP_TITLE~)
	)
)

-- *******************************************************************
--  Poly Ops: Face specific stuff
-- *******************************************************************

MacroScript EPoly_Bevel
ButtonText:~EPOLY_BEVEL_BUTTONTEXT~
Category:~EPOLY_BEVEL_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_BEVEL_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #Bevel)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #Bevel
		)
		Catch(MessageBox ~EPOLY_BEVEL_CAPTION~ Title:~EPOLY_BEVEL_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #Bevel
		)
		Catch(MessageBox ~EPOLY_BEVEL_OP_FAILED_CAPTION~ Title:~EPOLY_BEVEL_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Outline
ButtonText:~EPOLY_OUTLINE_BUTTONTEXT~
Category:~EPOLY_OUTLINE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_OUTLINE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #OutlineFace)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #OutlineFace
		)
		Catch(MessageBox ~EPOLY_OUTLINE_OP_FAILED_TOOLTIP~ Title:~EPOLY_OUTLINE_OP_FAILED_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #Outline
		)
		Catch(MessageBox ~EPOLY_OUTLINE_CAPTION~ Title:~EPOLY_OUTLINE_TITLE~)
	)
)

MacroScript EPoly_Inset
ButtonText:~EPOLY_INSET_BUTTONTEXT~
Category:~EPOLY_INSET_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_INSET_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #InsetFace)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #InsetFace
		)
		Catch(MessageBox ~EPOLY_INSET_CAPTION~ Title:~EPOLY_INSET_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #Inset
		)
		Catch(MessageBox ~EPOLY_INSET_OP_FAILED_CAPTION~ Title:~EPOLY_INSET_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Retriangulate
ButtonText:~EPOLY_RETRIANGULATE_CAPTION~
Category:~EPOLY_RETRIANGULATE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_RETRIANGULATE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 4 then subobjectlevel = 4
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #Retriangulate
			)
		)
		Catch(MessageBox ~EPOLY_RETRIANGULATE_OP_FAILED_CAPTION~ Title:~EPOLY_RETRIANGULATE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Flip
ButtonText:~EPOLY_FLIP_BUTTONTEXT~
Category:~EPOLY_FLIP_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FLIP_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do
	(
		If SubObjectLevel == undefined then Max Modify Mode
		-- default to Element level here:
		If SubObjectLevel < 4 then SubObjectLevel = 5
		else (
			Try(
				local A = Filters.GetModOrObj()
				if (Filters.Is_This_EditPolyMod A) then
				(
					if (subobjectLevel == 4) then A.buttonOp #FlipFace
					else A.ButtonOp #FlipElement
				)
				else A.buttonOp #FlipNormals
			)
			Catch(MessageBox ~EPOLY_FLIP_CAPTION~ Title:~EPOLY_FLIP_TITLE~)
		)
	)

)

MacroScript EPoly_Hinge
ButtonText:~EPOLY_HINGE_BUTTONTEXT~
Category:~EPOLY_HINGE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_HINGE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #HingeFromEdge)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #HingeFromEdge
		)
		Catch(MessageBox ~EPOLY_HINGE_CAPTION~ Title:~EPOLY_HINGE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.popupDialog #HingeFromEdge
		)
		Catch(MessageBox ~EPOLY_HINGE_OP_FAILED_CAPTION~ Title:~EPOLY_HINGE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Extrude_Along_Spline
ButtonText:~EPOLY_EXTRUDE_ALONG_SPLINE_BUTTONTEXT~
Category:~EPOLY_EXTRUDE_ALONG_SPLINE_CATEGORY~
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_EXTRUDE_ALONG_SPLINE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5}

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.enterPickMode #pickShape
		)
		Catch(MessageBox ~EPOLY_EXTRUDE_ALONG_SPLINE_CAPTION~ Title:~EPOLY_EXTRUDE_ALONG_SPLINE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj ()
			A.popupDialog #ExtrudeAlongSpline
		)
		Catch(MessageBox ~EPOLY_EXTRUDE_ALONG_SPLINE_OP_FAILED_APTION~ Title:~EPOLY_EXTRUDE_ALONG_SPLINE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_EditTri
ButtonText:~EPOLY_EDITTRI_BUTTONTEXT~
Category:~EPOLY_EDITTRI_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_EDITTRI_TOOLTIP~ 
-- Needs Icon
(
	-- active in Edge, Border, Face, Element levels:
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode() == #EditTriangulation)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 2 then subobjectlevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #EditTriangulation
		)
		Catch(MessageBox ~EPOLY_EDITTRI_OP_FAILED_CAPTION~ Title:~EPOLY_EDITTRI_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_ClearSmoothing
ButtonText:~EPOLY_CLEARSMOOTHING_BUTTONTEXT~
Category:~EPOLY_CLEARSMOOTHING_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CLEARSMOOTHING_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 4 then subobjectlevel = 4
			else (
				local A = Filters.GetModOrObj()
				if (Filters.Is_This_EditPolyObj A) then A.buttonOp #ClearSmoothingGroups
				else (
					A.smoothingGroupsToClear = -1
					A.smoothingGroupsToSet = 0
					A.ButtonOp #SetSmooth
				)
			)
		)
		Catch(MessageBox ~EPOLY_CLEARSMOOTHING_CAPTION~ Title:~EPOLY_CLEARSMOOTHING_TITLE~)
	)
)

MacroScript EPoly_Autosmooth
ButtonText:~EPOLY_AUTOSMOOTH_BUTTONTEXT~
Category:~EPOLY_AUTOSMOOTH_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_AUTOSMOOTH_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{5..6}

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 4 then subobjectlevel = 4
			else (
				local A = Filters.GetModOrObj()
				A.ButtonOp #Autosmooth
			)
		)
		Catch(MessageBox ~EPOLY_AUTOSMOOTH_CAPTION~ Title:~EPOLY_AUTOSMOOTH_TITLE~)
	)

)

-- *******************************************************************
--  Poly Ops: Parameter toggles
-- *******************************************************************

MacroScript EPoly_NURMS_Toggle
ButtonText:~EPOLY_NURMS_TOGGLE_BUTTONTEXT~
Category:~EPOLY_NURMS_TOGGLE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_NURMS_TOGGLE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EditPoly()
	On IsVisible Return Filters.Is_EditPoly()
	On IsChecked Do (
		Try ( $.surfSubdivide )
		Catch ( false )
	)

	On Execute Do
	(
		
		Try	
		(
		$.surfSubdivide = (not $.surfSubdivide)
		)
		Catch(MessageBox ~EPOLY_NURMS_TOGGLE_CAPTION~ Title:~EPOLY_NURMS_TOGGLE_TITLE~)
	)

)

MacroScript EPoly_SoftSel_Toggle
ButtonText:~EPOLY_SOFTSEL_TOGGLE_BUTTONTEXT~
Category:~EPOLY_SOFTSEL_TOGGLE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SOFTSEL_TOGGLE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			A.useSoftSel
		)
		Catch ( false )
	)

	On Execute Do
	(
		
		Try	
		(
			local A = Filters.GetModOrObj()
			A.useSoftSel = (not A.useSoftSel)
		)
		Catch(MessageBox ~EPOLY_SOFTSEL_TOGGLE_CAPTION~ Title:~EPOLY_SOFTSEL_TOGGLE_TITLE~)
	)

)

MacroScript EPoly_IgnoreBack_Toggle
ButtonText:~EPOLY_IGNOREBACK_TOGGLE_BUTTONTEXT~
Category:~EPOLY_IGNOREBACK_TOGGLE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_IGNOREBACK_TOGGLE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			A.ignoreBackfacing
		)
		Catch ( false )
	)

	On Execute Do (
		Try	(
			local A = Filters.GetModOrObj()
			A.ignoreBackfacing = (not A.ignoreBackfacing)
		)
		Catch(MessageBox ~EPOLY_IGNOREBACK_TOGGLE_CAPTION~ Title:~EPOLY_IGNOREBACK_TOGGLE_TITLE~)
	)

)

MacroScript EPoly_Toggle_Edge_Constraint
ButtonText:~EPOLY_TOGGLE_EDGE_CONSTRAINT_BUTTONTEXT~
Category:~EPOLY_TOGGLE_EDGE_CONSTRAINT_CATEGORY~
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_TOGGLE_EDGE_CONSTRAINT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			(A.constrainType == 1)
		)
		Catch ( false )
	)

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if A.constrainType == 1 then (A.constrainType = 0)
			else (A.constrainType = 1)
		)
		Catch (MessageBox ~EPOLY_TOGGLE_EDGE_CONSTRAINT_CAPTION~ Title:~EPOLY_TOGGLE_EDGE_CONSTRAINT_TITLE~)
	)
)

MacroScript EPoly_Toggle_Face_Constraint
ButtonText:~EPOLY_TOGGLE_FACE_CONSTRAINT_BUTTONTEXT~
Category:~EPOLY_TOGGLE_FACE_CONSTRAINT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_TOGGLE_FACE_CONSTRAINT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			(A.constrainType == 2)
		)
		Catch ( false )
	)

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if A.constrainType == 2 then (A.constrainType = 0)
			else (A.constrainType = 2)
		)
		Catch (MessageBox ~EPOLY_TOGGLE_FACE_CONSTRAINT_CAPTION~ Title:~EPOLY_TOGGLE_FACE_CONSTRAINT_TITLE~)
	)
)

-- This isn't a parameter toggle, exactly, but it acts similar, so we put it here
MacroScript EPoly_Toggle_Shaded_Faces
ButtonText:~EPOLY_TOGGLE_SHADED_FACES_BUTTONTEXT~
Category:~EPOLY_TOGGLE_SHADED_FACES_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_TOGGLE_SHADED_FACES_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			if subobjectLevel != 0 then (
				local A = Filters.GetModOrObj()
				A.buttonOp #ToggleShadedFaces
			)
		)
		Catch (MessageBox ~EPOLY_TOGGLE_SHADED_FACES_CAPTION~ Title:~EPOLY_TOGGLE_SHADED_FACES_TITLE~)
	)
)

-- *******************************************************************
--  Poly Ops: Selection conversion
-- *******************************************************************

MacroScript EPoly_Convert_Sel_To_Vertex
ButtonText:~EPOLY_CONVERT_SEL_TO_VERTEX_BUTTONTEXT~
Category:~EPOLY_CONVERT_SEL_TO_VERTEX_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CONVERT_SEL_TO_VERTEX_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{3..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{3..6}

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ConvertSelection #CurrentLevel #Vertex
			subobjectLevel = 1
		)
		Catch (MessageBox ~EPOLY_CONVERT_SEL_TO_VERTEX_CAPTION~ Title:~EPOLY_CONVERT_SEL_TO_VERTEX_TITLE~)
	)
)

MacroScript EPoly_Convert_Sel_To_Edge
ButtonText:~EPOLY_CONVERT_SEL_TO_EDGE_BUTTONTEXT~
Category:~EPOLY_CONVERT_SEL_TO_EDGE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CONVERT_SEL_TO_EDGE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2,5..6}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2,5..6}

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ConvertSelection #CurrentLevel #Edge
			subobjectLevel = 2
		)
		Catch (MessageBox ~EPOLY_CONVERT_SEL_TO_EDGE_CAPTION~ Title:~EPOLY_CONVERT_SEL_TO_EDGE_TITLE~)
	)
)

MacroScript EPoly_Convert_Sel_To_Face
ButtonText:~EPOLY_CONVERT_SEL_TO_FACE_BUTTONTEXT~
Category:~EPOLY_CONVERT_SEL_TO_FACE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_CONVERT_SEL_TO_FACE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPolySpecifyLevel #{2..4}
	On IsVisible Return Filters.Is_EPolySpecifyLevel #{2..4}

	On Execute Do (
		Try (
			if subobjectLevel == undefined then Max Modify Mode
			local A = Filters.GetModOrObj()
			A.ConvertSelection #CurrentLevel #Face
			subobjectLevel = 4
		)
		Catch (MessageBox ~EPOLY_CONVERT_SEL_TO_FACE_CAPTION~ Title:~EPOLY_CONVERT_SEL_TO_FACE_TITLE~)
	)
)





-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAaLuJ7Cik1iCdi+s7PMTq25yUTrdQk0QYk
-- 6l3FLCek2B+WvRBnvHOlbAYO/ayNveyMQQvTa7f5jBB3pP1Fb6Tn7RDGNHzs+x9g
-- gGmsQSUez/RV+JMjdQWpJE1y/DM5RA1FGCS5Uf/45aegE+BnO0yNdo/qOQyDg/zx
-- E044oWNkLeDNAi3m4srkvqfxkdqVm7SENtExv751bB/6n0c6jjibJEQNYz7kUMNK
-- /XwomCGBWnLnUJHOb/Q+Jxf9PIvEaHGqfnUjDihbrVh7NSG3tDfaePGQhW7NXoui
-- 8tBQ27tY/euqQY1Jdlv8vYbKjQPmSALgPJxV6VQ757dSQ+V9Jbbs
-- -----END-SIGNATURE-----